module testClient


derive gForm []
derive gUpd []

derive gForm 	Person, Gender
derive gUpd 	Person, Gender
derive gParse 	Person, Gender
derive gPrint 	Person, Gender
derive gerda 	Person, Gender
derive read 	Person, Gender
derive write 	Person, Gender

import StdEnv, StdiTasks, iDataTrivial

:: Person =  { name				:: String
			 , e_mail			:: String
			 , dateOfBirth		:: HtmlDate
			 , gender			:: Gender
			 }
:: Gender =  Female | Male

Start world = multiUserTask [](foreverTask twoWorkers <<@ TxtFile) world

twoWorkers 
=				[Txt "Define new initial form:"]
				?>> editTask "onServer" createDefault
  =>> \fi ->		[Txt "Assign first worker:"]
  				?>> editTask "Assign" 1
  =>> \w1 ->	[Txt "Assign second worker:"]
  				?>> editTask "Assign" 2
  =>> \w2 ->	fillform w1 fi -||- fillform w2 fi
  =>> \fr ->	[Txt "resulting form received from fastest worker:", toHtml fr]
  				?>> editTask "OK" Void	
where
	fillform w f = w @:: OnClient @>> fillPersonForm f
//	fillform w f = w @:: fillPersonForm f



fillPersonForm  :: Person -> Task Person
fillPersonForm p
= doubleCheckForm  p check
where
	check p
	| p.name 		== "" = (False, [YTxt "Error: Please fill in your name !"])			
	| p.e_mail 		== "" = (False, [YTxt "Error: Please fill in e-mail address !"])			
	| illegal p.e_mail 	  = (False, [YTxt "Error: Illegal e-mail address !"])			
	| otherwise = (True, [])			

	illegal s = not (isMember '@' [c \\ c <-: s])

	YTxt message
	= Font [Fnt_Color (`Colorname Yellow)] [B [] message]

doubleCheckForm  :: a (a -> (Bool, [BodyTag]))  -> (Task a) | iData a
doubleCheckForm  a preda = newTask "fillform" fillform`
where
	fillform` 
	=					[Txt "Please fill in the form:",Br,Br] 
						?>> editTask "OK" a //editTaskPred a preda
		=>> \na ->  	chooseTask [Txt "Received information:", Br, Br, toHtml na, Br, Txt "Is everything correct ?", Br]
						[ ("Yes", return_V na)
						, ("No",  doubleCheckForm  na preda)
						] 







